import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestPageEdit:
    data = BaseRequest().api_load(path_setting.PAGE_EDIT)
    page_edit_case, page_edit_data = get_ids(data,'page_edit')

    @pytest.mark.parametrize("param", page_edit_data, ids=page_edit_case)
    def test_page_edit(self, param):
        edit = achelous_request().special_edit("32244157", "aha自定义专题创建", "0", "2021-08-01 00:00:00","2021-09-30 00:00:00", "1", "啊哈自定义专题创建标题", "啊哈自定义专题创建分享语","https://heras.igengmei.com/4d5eef0a-78dd-43b3-98b7-137d2341f106-1628565831259")
        list = achelous_request().special_list('1', '10', '', '', '', '', '', '1', '0', '', '')
        param['visualpage_id'] = list['data']['info_list'][0]['page_id']
        param['name'] = edit['data']['name']
        r = achelous_request().page_edit(param['visualpage_id'], param['name'], param['visual_info'])
        if r['msg'] == 'success':
            assert r['data']['visualgroup_id'] == param['assert']
            print('自定义专题组件库成功保存，啦啦啦')
        else:
            assert r['code'] == param['assert_error']
            print('自定义专题组件库保存失败，呜呜呜')