import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestSpecialDelete:
    data = BaseRequest().api_load(path_setting.SPECIAL_DELETE)
    special_delete_case, special_delete_data = get_ids(data, "special_delete")

    @pytest.mark.parametrize("param", special_delete_data, ids=special_delete_case)
    def test_special_delete(self, param):
        edit = achelous_request().special_edit("32244157","aha自定义专题创建","0","2021-08-01 00:00:00","2021-09-30 00:00:00","1","啊哈自定义专题创建标题","啊哈自定义专题创建分享语","https://heras.igengmei.com/4d5eef0a-78dd-43b3-98b7-137d2341f106-1628565831259")
        param['ids'] = edit['data']['id']

        r = achelous_request().special_delete(param['ids'])
        if r['message'] == 'success':
            print("自定义专题删除了")
        else:
            print("自定义专题无法删除")



