import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestSpecialEdit:
    data = BaseRequest().api_load(path_setting.SPECIAL_EDIT)
    special_edit_case, special_edit_data = get_ids(data, "special_edit")

    @pytest.mark.parametrize("param", special_edit_data, ids=special_edit_case)
    def test_special_edit(self, param):
        r = achelous_request().special_edit(param['user_id'], param['name'], param['id'], param['start_time'], param['end_time'], param['is_online'], param['share_title'], param['share_content'], param['share_pic'])
        if r['message'] == 'success':
            assert r["data"]["name"] == param["assert"]
            print("自定义专题创建成功~")
        else:
            assert r['code'] == param['assert_error']
            print("自定义专题创建失败，呜呜呜")




