import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestSpecialList:
    data = BaseRequest().api_load(path_setting.SPECIAL_LIST)
    special_list_case, special_list_data = get_ids(data, 'special_list')

    @pytest.mark.parametrize("param", special_list_data, ids= special_list_case)
    def test_special_list(self,param):
        r = achelous_request().special_list(param['page_index'], param['page_capacity'], param['page_id'], param['name'], param['creator_name'], param['create_time_gt'], param['create_time_lt'], param['is_online'], param['status'], param['start_time'], param['end_time'])
        if r['msg'] == 'success':
            assert r['data']['page_index'] == param['assert']
            print('搜索自定义专题成功啦~~~')
        else:
            assert r['code'] == param['assert_error']
            print('自定义专题搜索失败了!!!')

