import pytest

import path_setting
from all_om_api.achelous_request import achelous_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestUnitUpdate:
    data = BaseRequest().api_load(path_setting.UNIT_UPDATE)
    unit_update_case, unit_update_data = get_ids(data, "unit_update")

    @pytest.mark.parametrize("param", unit_update_data, ids=unit_update_case)
    def test_unit_update(self, param):
        edit = achelous_request().special_edit("32244157","aha自定义专题创建","0","2021-08-01 00:00:00","2021-09-30 00:00:00","1","啊哈自定义专题创建标题","啊哈自定义专题创建分享语","https://heras.igengmei.com/4d5eef0a-78dd-43b3-98b7-137d2341f106-1628565831259")
        list = achelous_request().special_list('1', '10', '', '', '', '', '', '1', '0', '', '')
        param['page_id'] = list['data']['info_list'][0]['page_id']
        param['name'] = edit['data']['name']

        r = achelous_request().unit_update(param['page_id'], param['order'], param['unit'])
        if r['msg'] == 'success':
            assert r['data']['unit']['module_name'] == param['assert']
            print('组件成功保存啦，啦啦啦')
        else:
            assert r['code'] == param['assert_error']
            print('组件保存失败了，呜呜呜')

        #调用组件库保存接口
        achelous_request().page_edit("param['page_id']", "param['name']", "r['data']['unit']")


