import path_setting
from in_common.base_request import BaseRequest


class im_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.CONVERSATION_DETAIL_CONFIG)

    def conversation_detail(self,current_city_id,begin_msg_id,conversation_type,end_msg_id,referrer):
        self.params["current_city_id"] = current_city_id
        self.params["begin_msg_id"] = begin_msg_id
        self.params["conversation_type"] = conversation_type
        self.params["end_msg_id"] = end_msg_id
        self.params["referrer"] = referrer
        return self.api_send(self.data["conversation_detail"])

    def auto_msg(self,version,uqid,trace_id,conversation_id):
        self.params["version"] = version
        self.params["uqid"] = uqid
        self.params["trace_id"] = trace_id
        self.params["conversation_id"] = conversation_id
        return self.api_send(self.data["auto_msg"])

    def send_msg(self, conversation_id, is_system, referrer, referrer_id, msg_type, content, extra):
        self.params["conversation_id"] = conversation_id
        self.params["is_system"] = is_system
        self.params["referrer"] = referrer
        self.params["referrer_id"] = referrer_id
        self.params["msg_type"] = msg_type
        self.params["content"] = content
        self.params["extra"] = extra
        return self.api_send(self.data["send_msg"])


if __name__ == '__main__':
    print(im_request().conversation_detail("beijing", 0, 4, 0,  "message_home"))
    print("第二个接口")
    print(im_request().auto_msg("7.42.2","1B519701-A4F5-453E-9D99-140B5AF697A0","2021/04/22/1722/70a1791606d5",368))
    print("send_msg")
    print(im_request().send_msg("368", 0, "message_home", "", 0, "您好，我想咨询一下", {}))





