import path_setting
from in_common.base_request import BaseRequest


class janus_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.CONTENTV7_CONFIG)
        self.data = self.api_load(path_setting.HOSPITALSEARCH_CONFIG)

    #搜索结果页-综合/百科tab
    def content_v7(self, query, device_id, current_city_id, version, is_first, tab_type, offset):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #是否为第一次请求
        self.params['is_first'] = is_first
        #类型
        self.params['tab_type'] = tab_type
        #请求的页数 0，10，20
        self.params['offset'] = offset

        return self.api_send(self.data['content_v7'])

    #医院主页搜索
    def hospital_search(self, query, device_id, hospital_id, current_city_id, version, offset):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #医院id
        self.params['hospital_id'] = hospital_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #请求的页数 0，10，20
        self.params['offset'] = offset

        return self.api_send(self.data['hospital_search'])

    #购物车-猜你喜欢列表
    def mine_guess_you_like(self):
        return self.api_send(self.data["mine_guess_you_like"])


if __name__ == '__main__':
    #打印购物车-猜你喜欢列表接口返回
    print(janus_request().mine_guess_you_like())


