import path_setting
import requests
import yaml
"""
此文件是封装session的
"""

class LoginFunction:

    def __init__(self):
        self.host = self.login_yaml_load(path_setting.HOSTYAML_CONFIG)
        self.params = self.login_yaml_load(path_setting.LOGIN_FUNCTION_DATA)

    def login_yaml_load(self, path) -> list:
        with open(path, encoding='utf-8') as f:
            return yaml.safe_load(f)

    def get_session(self):
        hostList = self.host['develop_host']
        for key in hostList:
            if 'backend' == key:
                return self.get_develop_session()
            elif 'doctor' == key:
                return self.get_doctor_session()

    def get_develop_session(self):
        url = self.host["develop_host"]["backend"] + self.params["backend_login"]["url"]
        s = requests.session()
        r = s.request(
            self.params["backend_login"]["method"],
            url=url,
            params=self.params["backend_login"]["params"],
            data=self.params["backend_login"]["data"],
            headers={'Connection': 'close'}
        )
        return s

    def get_doctor_session(self):
        url = self.host["develop_host"]["doctor"] + self.params["doctor_login"]["url"]
        s = requests.session()
        r = s.request(
            self.params["doctor_login"]["method"],
            url=url,
            params=self.params["doctor_login"]["params"],
            data=self.params["doctor_login"]["data"],
            headers={'Connection': 'close'}
        )
        return s






if __name__ == '__main__':
    LoginFunction().get_session()