import pytest

from all_backend_api.hospitals_v2_request import hospitals_v2_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestServices:
    data = BaseRequest().api_load(path_setting.HOSPITAL_SERVICE)
    services_case, services_data = get_ids(data, "services")

    @pytest.mark.parametrize("param", services_data, ids=services_case)
    def test_detail(self, param):
        r = hospitals_v2_request().services()

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]
            assert r["data"]["services"][0]["service_item_id"] == param["assert_sku"]
            assert r["data"]["services"][0]["service_id"] == param["assert_spu"]
            assert r["data"]["services"][0]["price_info"]["has_discount"] == param["assert_discount"]
            assert r["data"]["services"][0]["sales_info"][0]["type"] == param["assert_sales"]
            assert r["data"]["services"][0]["exposure"]["card_type"] == param["assert_card_type"]
            assert r["data"]["services"][0]["title"] == param["assert_title"]
            assert r["data"]["tag_distribution"][0]["selected"] == param["assert_tagselected"]




