import path_setting
from in_common.base_request import BaseRequest


class janus_request(BaseRequest):
    def __init__(self):
        #捜索结果页-综合/百科tab
        self.data = self.api_load(path_setting.CONTENTV7_CONFIG)

        #医院主页捜索
        self.data = self.api_load(path_setting.HOSPITALSEARCH_CONFIG)

        #品类聚合页面商品列表
        self.data = self.api_load(path_setting.TAG_SERVICE_CONFIG)

        #品类聚合页面标签和专场
        self.data = self.api_load(path_setting.POLYMER_CONFIG)

        #医生医院sug列表
        self.data = self.api_load(path_setting.KEYWORDTIP_CONFIG)

        #次卡商详页
        self.data = self.api_load(path_setting.BEAUTY_CARD_DETAIL_CONFIG)

        #直播polling循环
        self.data = self.api_load(path_setting.POLLING_CONFIG)

        #直播获取美颜
        #self.data = self.api_load(path_setting.BEAUTY_CONFIG)




    #搜索结果页-综合/百科tab
    def content_v7(self, query, device_id, current_city_id, version, is_first, tab_type, offset):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #是否为第一次请求
        self.params['is_first'] = is_first
        #类型
        self.params['tab_type'] = tab_type
        #请求的页数 0，10，20
        self.params['offset'] = offset

        return self.api_send(self.data['content_v7'])

    #医院主页搜索
    def hospital_search(self, query, device_id, hospital_id, current_city_id, version, offset, size):
        #搜索词
        self.params['query'] = query
        #设备号
        self.params['device_id'] = device_id
        #医院id
        self.params['hospital_id'] = hospital_id
        #当前城市
        self.params['current_city_id'] = current_city_id
        #APP版本
        self.params['version'] = version
        #请求的页数 0，10，20
        self.params['offset'] = offset
        # 单页请求数量
        self.params['size'] = size

        return self.api_send(self.data['hospital_search'])

    #购物车-猜你喜欢列表
    def mine_guess_you_like(self):
        return self.api_send(self.data["mine_guess_you_like"])

    #商祥页-详情
    def product_detail(self, service_id, service_item_id, version):
        self.params["service_id"] = service_id
        self.params["service_item_id"] = service_item_id
        self.params["version"] = version
        return self.api_send(self.data["product_detail"])

    #商祥页-sku信息
    def sku_info(self, service_id, service_item_id):
        self.params["service_id"] = service_id
        self.params["service_item_id"] = service_item_id
        return self.api_send(self.data["sku_info"])

    #商祥页-美券列表-我的美券点击-744版本及以后-新接口
    def product_coupon_my_list(self, start_num, tab_id):
        self.params["start_num"] = start_num
        self.params["tab_id"] = tab_id
        return self.api_send(self.data["product_coupon_my_list"])

    # 品类聚合页面商品列表
    def tag_service(self, size, tag_ids, offset, tag_id, version, device_id):
        print("fgx")
        self.params['size'] = size
        self.params['tag_ids'] = tag_ids
        self.params['offset'] = offset
        self.params['tag_id'] = tag_id
        self.params['version'] = version
        self.params['device_id'] = device_id

        return self.api_send(self.data["tag_service"])

    # 品类聚合页面标签和专场
    def polymer(self, version, category_polymer_id, device_id):
        self.params['version'] = version
        self.params['category_polymer_id'] = category_polymer_id
        self.params['device_id'] = device_id

        return self.api_send(self.data["polymer"])

    #医生医院sug列表
    def keyword_tip(self, query, lat, lng, version, device_id = '97B6764B-2135-4761-9911-701C38CBC272', tab_type = '0'):
        self.params['query'] = query
        self.params['lat'] = lat
        self.params['lng'] = lng
        self.params['version'] = version

        return  self.api_send(self.data['keyword_tip'])

    #次卡-确认订单
    def beauty_card_order_confirm(self, sku_id, number, use_bc_coupon, bc_coupon_id):
        self.params["sku_id"] = sku_id
        self.params["number"] = number
        self.params["use_bc_coupon"] = use_bc_coupon
        self.params["bc_coupon_id"] = bc_coupon_id
        return self.api_send(self.data["beauty_card_order_confirm"])

    #次卡-确认订单页面-修改手机号
    def beauty_card_update_phone(self, authorize_phone, authorize_phone_type, vfc_code):
        self.params["authorize_phone"] = authorize_phone
        self.params["authorize_phone_type"] = authorize_phone_type
        self.params["vfc_code"] = vfc_code
        return self.api_send(self.data["beauty_card_update_phone"])

    #次卡-提交订单
    def beauty_card_order_submit(self, phone, sku_id, number, is_doctor_see, gain_coupon_id, deduction_price):
        self.params["phone"] = phone
        self.params["sku_id"] = sku_id
        self.params["number"] = number
        self.params["is_doctor_see"] = is_doctor_see
        self.params["gain_coupon_id"] = gain_coupon_id
        self.params["deduction_price"] = deduction_price
        return self.api_send(self.data["beauty_card_order_submit"])

    #次卡-支付平台
    def beauty_card_payment_method(self, payment_id):
        self.params["payment_id"] = payment_id
        return self.api_send(self.data["beauty_card_payment_method"])

    #次卡-微信支付
    def beauty_card_prepay_wechat(self, payment_id):
        self.params["payment_id"] = payment_id
        return self.api_send(self.data["beauty_card_prepay_wechat"])

    #次卡-支付宝支付
    def beauty_card_prepay_alipay(self, is_huabei, payment_id):
        self.params["is_huabei"] = is_huabei
        self.params["payment_id"] = payment_id
        return self.api_send(self.data["beauty_card_prepay_alipay"])

    #次卡-订单详情
    def beauty_card_payment_detail(self, payment_id):
        self.params["payment_id"] = payment_id
        return self.api_send(self.data["beauty_card_payment_detail"])

    #次卡-取消订单
    def beauty_card_payment_delete(self, payment_id):
        self.params["payment_id"] = payment_id
        return self.api_send(self.data["beauty_card_payment_delete"])

    #次卡-申请退款
    def beauty_card_refund_info(self, order_id):
        self.params["order_id"] = order_id
        return self.api_send(self.data["beauty_card_refund_info"])

    #次卡-提交退款申请
    def beauty_card_refund_submit(self, order_id, reason_id, reason_text, reason_type):
        self.params["order_id"] = order_id
        self.params["reason_id"] = reason_id
        self.params["reason_text"] = reason_text
        self.params["reason_type"] = reason_type
        return self.api_send(self.data["beauty_card_refund_submit"])

    # 新版本我的美券列表
    def product_my_list(self,start_num,tab_id):
        self.params['start_num'] = start_num
        self.params['tab_id'] = tab_id
        return self.api_send(self.data['coupon_my_list'])

    # 次卡订单详情页（未使用 和 部分使用 和 已使用）
    def beauty_card_order_detail(self, order_id):
        self.params['order_id'] = order_id
        return self.api_send(self.data['beauty_card_order_detail'])

    # 次卡商详页
    def beauty_card_detail(self, spu_id, sku_id, version):
        self.params['spu_id'] = spu_id
        self.params['sku_id'] = sku_id
        self.params['version'] = version

        return self.api_send(self.data["beauty_card_detail"])

    # 次卡商详-适应机构列表
    def service_hospital(self, offset, sku_id, size, version, current_city_id, lat, lng):
        self.params['offset'] = offset
        self.params['sku_id'] = sku_id
        self.params['size'] = size
        self.params['version'] = version
        self.params['current_city_id'] = current_city_id
        self.params['lat'] = lat
        self.params['lng'] = lng

        return self.api_send(self.data["service_hospital"])

    # 首页（灰度）feed-推荐商品类型tab[除必要参数外其余参数使用默认参数形式方便之后调整]
    def feed_service(self, tab_value, first_load, version = '7.42.2' , device_id = 'androidid_49973caa1b578d85', current_city_id = 'beijing'):
        self.params['version'] = version
        self.params['device_id'] = device_id
        self.params['tab_value'] = tab_value
        self.params['current_city_id'] = current_city_id
        self.params['first_load'] = first_load

        return self.api_send(self.data["feed_service"])

    # 直播-点击【设置封面】
    def page_rules(self, version, current_city_id, page_name, device_id = '97B6764B-2135-4761-9911-701C38CBC272'):
        self.params['version'] = version
        self.params['current_city_id'] = current_city_id
        self.params['page_name'] = page_name

        return self.api_send(self.data["page_rules"])

    #直播poling循环
    def polling(self,stream_id,is_first):
        self.params["stream_id"] = stream_id
        self.params["is_first"] = is_first

        return self.api_send(self.data["polling"])

    #直播-主播获取美颜效果
    def beauty(self,channel_id):
        self.params["channel_id"] = channel_id
        return self.api_send(self.data["beauty"])
    #直播-主播修改美颜效果
    def beauty_post(self,channel_id,is_open,smooth,white,rosy):
        self.params["channel_id"] = channel_id
        self.params["is_open"] = is_open
        self.params["smooth"] = smooth
        self.params["white"] = white
        self.params["rosy"] = rosy
        return self.api_send(self.data["beauty_post"])



if __name__ == '__main__':
    #打印购物车-猜你喜欢列表接口返回
#    print(janus_request().mine_guess_you_like())
    #打印商祥页-详情接口返回
    print(janus_request().product_detail("5857263", "618788", "7.43.0"))
    #打印商祥页-sku信息接口返回
    print(janus_request().sku_info("5857263", "618788"))
    #打印商祥页-美券列表-我的美券点击-744版本及以后-新接口返回
    print(janus_request().product_coupon_my_list(0, 0))

    #品类聚合页面商品列表接口返回
#    print(janus_request().tag_service())
    print("fgx")

    #品类聚合页面标签和专场
#    print(janus_request().polymer())
    print("fgx")

    #打印次卡-确认订单接口返回
    print(janus_request().beauty_card_order_confirm("10176", 1, 1, 0))
    #打印次卡-确认订单页面-修改手机号接口返回
    print(janus_request().beauty_card_update_phone("+8612348543876", 1, "084430"))
    #打印次卡-提交订单接口返回
    print(janus_request().beauty_card_order_submit("12345678912", "10176", 1, 1, 0, 0))
    #打印次卡-支付平台接口返回
    print(janus_request().beauty_card_payment_method("101670448736595"))

    print(janus_request().product_my_list(0, 0))
    # 次卡商详页-适应机构
    print(janus_request().beauty_card_detail("100018", "10046",  "100018", "7.44.0", "beijing", "40.001879", "116.487194"))
    # 次卡商详页
    print(janus_request().service_hospital("0", "10046",  "1", "7.44.0", "beijing", "40.001879", "116.487194"))
    # #打印购物车-猜你喜欢列表接口返回
    # print(janus_request().mine_guess_you_like())
    # #打印商祥页-详情接口返回
    # print(janus_request().product_detail("5857263", "618788", "7.43.0"))
    # #打印商祥页-sku信息接口返回
    # print(janus_request().sku_info("5857263", "618788"))
    # #打印商祥页-美券列表-我的美券点击-744版本及以后-新接口返回
    # print(janus_request().product_coupon_my_list(0, 0))
    #
    # #品类聚合页面商品列表接口返回
    # print(janus_request().tag_service())
    # print("fgx")
    #
    # #品类聚合页面标签和专场
    # print(janus_request().polymer())
    # print("fgx")
    #
    # #打印次卡-确认订单接口返回
    # print(janus_request().beauty_card_order_confirm("10176", 1, 1, 0))
    # #打印次卡-确认订单页面-修改手机号接口返回
    # print(janus_request().beauty_card_update_phone("+8612348543876", 1, "084430"))
    # #打印次卡-提交订单接口返回
    # print(janus_request().beauty_card_order_submit("12345678912", "10176", 1, 1, 0, 0))
    # #打印次卡-支付平台接口返回
    # print(janus_request().beauty_card_payment_method("101670448736595"))
    # #打印次卡-微信支付接口返回
    # print(janus_request().beauty_card_prepay_wechat("101353630959868"))
    # # 打印次卡-支付宝支付接口返回
    # print(janus_request().beauty_card_prepay_alipay(0, "101353630959868"))
    # #打印次卡 - 订单详情接口返回
    # print(janus_request().beauty_card_payment_detail("101353630959868"))
    # #打印次卡 - 取消订单接口返回
    # print(janus_request().beauty_card_payment_delete("101353630959868"))
    # #打印次卡-申请退款接口返回
    # print(janus_request().beauty_card_refund_info("102217820485006"))
    #打印次卡-提交退款申请接口返回
    # print(janus_request().beauty_card_refund_submit("102813852173916", 3, "个人身体原因", 0))
    print(janus_request().beauty_card_order_detail(102247770691611))
    # print(janus_request().product_my_list(0, 0))

    #直播-点击【设置封面】
    print("直播-点击【设置封面】")
    print(janus_request().page_rules("744.2", "beijing", "post_add_pic"))
    #直播-主播获取美颜
    print("meiyan")
    print(janus_request().beauty("739"))
    #直播-主播修改美颜
    print("change meiyan")
    print(janus_request().beauty_post("739","true","0.60","0.40","0.70"))

