import path_setting
from in_common.base_request import BaseRequest


class tractate_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.TRACTATE_CONFIG)

    # 帖子详情页内容
    def tractate_detail(self, current_city_id, tractate_id, data_type):
        self.params["current_city_id"] = current_city_id
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["tractate_detail"])

    # 帖子相关美购
    def tractate_related_service(self, current_city_id, tractate_id, data_type):
        self.params["current_city_id"] = current_city_id
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["related_service"])

    # 帖子外显评论
    def reply(self, current_city_id, id, data_type):
        self.params["current_city_id"] = current_city_id
        self.params["id"] = id
        self.params["data_type"] = data_type
        return self.api_send(self.data["reply"])

    # 帖子收藏
    def favor(self, tractate_id, data_type):
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["favor"])

    # 帖子取消收藏
    def cancelfavor(self, tractate_id, data_type):
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        return self.api_send(self.data["cancelfavor"])

    # 帖子点赞
    def tractate_vote(self, tractate_id, data_type, reply_id):
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        self.params["reply_id"] = reply_id
        return self.api_send(self.data["tractate_vote"])

    # 帖子取消点赞
    def tractate_cancelvote(self, tractate_id, data_type, reply_id):
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        self.params["reply_id"] = reply_id
        return self.api_send(self.data["tractate_cancelvote"])

    # 帖子创建一级&二级评论
    def publish_reply(self, tractate_id, data_type, reply_id, content):
        self.params["tractate_id"] = tractate_id
        self.params["data_type"] = data_type
        self.params["reply_id"] = reply_id
        self.params["content"] = content
        return self.api_send(self.data["publish_reply"])

    # 帖子创建--登录下
    def create(self):
        return self.api_send(self.data["create"])

    # 帖子创建--未登录下
    def create_unlogin(self):
        return self.api_send(self.data["create_unlogin"])
