import pytest

from all_backend_api.doctor_v2_request import doctor_v2_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestServices:
    data = BaseRequest().api_load(path_setting.DOCTOR_V2_SERVICE)
    services_case, services_data = get_ids(data, "services")

    @pytest.mark.parametrize("param", services_data, ids=services_case)
    def test_services(self, param):
        r = doctor_v2_request().services()

        if r["error"] == 0:
            assert r["error"] == param["assert_error"]
