import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestFreeRecruitDetail:
    data = BaseRequest().api_load(path_setting.FREE_RECRUIT_DETAIL)
    free_recruit_detail_case, free_recruit_detail_data = get_ids(data, "free_recruit_detail")

    @pytest.mark.parametrize("param", free_recruit_detail_data, ids=free_recruit_detail_case)
    def test_free_recruit_detail_case(self, param):
        r = feed_request().free_recruit_detail(param["current_city_id"], param["id"])
        if r["error"] == 0:
            assert r["data"]["free_recruit"]["id"] != param["assert"]




