import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.gmai_request import gmai_request

# 测肤结果页
class TestSkinNewReport:
    data = BaseRequest().api_load(path_setting.GMAI_SKIN_NEWREPORT_DATA)
    skinnewReport_case, skinnewReport_data = get_ids(data, "skin_newReport")

    @pytest.mark.parametrize("param", skinnewReport_data, ids=skinnewReport_case)
    def test_skinnewReport(self,param):
        r = gmai_request().skin_newReport(param["version"], param["image_url"])
        if r["error"] == 0:
            data = r.get("data")

            # 大家都在买
            packages = data.get("packages")
            assert len(packages) == 6
            for item in packages:
                package_id = item["package_id"]
                package_name = item["package_name"]
                tag_name = item["tag_name"]
                gengmei_url = item["gengmei_url"]
                print(package_id,package_name,tag_name,gengmei_url)
                assert package_id not in (None, "")
                assert package_name not in (None, "")
                assert tag_name not in (None, "")
                assert gengmei_url == "gengmei://service?service_id={}&has_task=0&sign_task_seconds=10&sign_points=20".format(package_id)

            # 皮肤检测结果，重点关注部分
            disadvantage_tabs = data.get("disadvantage_tabs")
            result_word = disadvantage_tabs[0].get("result_word")
            analysis = disadvantage_tabs[0]["tab_data"]["analysis"]
            seriousness = disadvantage_tabs[0]["tab_data"]["seriousness"]
            print(result_word, analysis, seriousness)
            assert result_word not in (None, "")
            assert analysis not in (None, "")
            assert seriousness not in (None, "")

            # 皮肤检测结果，其他部分
            advantage_tabs = data.get("advantage_tabs")
            for item in advantage_tabs:
                result_word = item.get("result_word")
                analysis = item["tab_data"]["analysis"]
                seriousness = item["tab_data"]["seriousness"]
                print(result_word, analysis, seriousness)
                # assert result_word not in (None, "")   测试环境有部分数据没有配置
                # assert analysis not in (None, "")
                # assert seriousness not in (None, "")

            # 用户信息部分
            user_info = r["data"]["user_info"]
            count = user_info["count"]
            assert count == 1
            # 底部按钮
            bottom_buttons = r["data"]["bottom_buttons"]
            assert bottom_buttons[0]["gm_url"] == "gengmei://scan_faceimage?face_skin_tab_index=0&amp;has_task=0"
            assert bottom_buttons[0]["name"] == "AI测颜值"
            assert bottom_buttons[1]["gm_url"] == "gengmei://transfer_consult?conversation_type=4"
            assert bottom_buttons[1]["name"] == "变美1V1咨询"
