import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.hybrid_api_topic_request import hybrid_api_topic_request


class TestDiaryVote:
    data = BaseRequest().api_load(path_setting.DIARY_VOTE)
    diary_vote_case, diary_vote_data = get_ids(data, "diary_vote")

    @pytest.mark.parametrize("param", diary_vote_data, ids=diary_vote_case)
    def test_api_topic_vote(self, param):
        # print(111)
        # print(diary_vote_case)
        r = hybrid_api_topic_request().diary_detail(param["topic_id"])
        # print(r)
        # 可以多加一个d代表详情页
        if r["error"] == 0:
            assert r["error"] == param["assert1"]
            # 如果没有点过赞，就先校验点赞之后再取消点赞。【最后保持取消点赞的状态】
            if not r["data"]["data"]["is_liked"]:
                # print(222)
                vote = hybrid_api_topic_request().diary_vote(param["id"])
                assert vote["error"] == 0
                # 校验二次点赞无效
                vote = hybrid_api_topic_request().diary_vote(param["id"])
                assert vote["message"] == param["assert3"]
                assert vote["error"] == 1
                # 取消点赞，回到取消点赞的状态
                cancelvote = hybrid_api_topic_request().diary_cancelvote(param["id"])
                assert cancelvote["error"] == 0
            else:
                # 如果是已经点过赞的状态就直接取消点赞
                # print(111)
                cancelvote = hybrid_api_topic_request().diary_cancelvote(param["id"])
                assert cancelvote["error"] == 0





# if r["error"] == 1:
#     assert r["message"] ==param["assert2"]


#     收藏之后取消收藏
# r1 = diary_isfavor_request().diary_cancelfavor()
# if r["error"] == 0:
#     assert r["error"] == param["assert"]






