import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.hybrid_request import hybrid_request



class TestQuestionV1:
    data = BaseRequest().api_load(path_setting.QUESTION_DETAIL)
    questionv1_case, questionv1_data = get_ids(data, "question_v1")

    @pytest.mark.parametrize("param", questionv1_data, ids=questionv1_case)
    def test_question_v1(self, param):
        r = hybrid_request().question_v1()
        assert r["error"] == param["error"]
        if r["error"] == 0:
            assert r["config"]["has_login"] is not None and r["config"]["has_login"] is not ""
            assert r["config"]["url_base"] is not None and r["config"]["url_base"] is not ""
            assert r["config"]["host_url"] is not None and r["config"]["host_url"] is not ""
            assert r["data"]["is_favored"] is not None and r["data"]["is_favored"] is not ""
            assert r["data"]["answer_count"] is not None and r["data"]["answer_count"] is not ""
            assert r["data"]["answer_level_lte2_nums"] is not None and r["data"]["answer_level_lte2_nums"] is not ""
            assert r["data"]["answer_level_gte3_nums"] is not None and r["data"]["answer_level_gte3_nums"] is not ""
            assert r["data"]["is_following"] is not None and r["data"]["is_following"] is not ""
            assert r["data"]["id"] is not None and r["data"]["id"] is not ""
            assert r["data"]["title"] is not None and r["data"]["title"] is not ""
            assert r["data"]["content"] is not None and r["data"]["content"] is not ""



    # 如果没有点过赞，就先校验点赞之后再取消点赞。【最后保持取消点赞的状态】






