

#搜索结果页-医生/医院tab
import pytest

import path_setting
from all_backend_api.search_request import search_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestContentV6:
    data = BaseRequest().api_load(path_setting.CONTENTV6)
    contentv6_case, contentv6_data = get_ids(data, "content_v6")

    @pytest.mark.parametrize("param", contentv6_data, ids=contentv6_case)
    def test_content_v6(self, param):
        print(param['query'])
        r = search_request().content_v6(param["query"], param["device_id"], param["current_city_id"], param["version"], param["is_first"], param["tab_type"], param["offset"], param["size"])
        if r["error"] == 0:
            if param["tab_type"] == 3:
                assert r["data"]["hospitals"][0]["name"] == param["assert"]
            if param["tab_type"] == 4:
                assert r["data"]["doctors"][0]["name"] == param["assert"]
        if r["error"] == 1:
            assert r["message"] == param["assert"]