import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tractate_request import tractate_request



class TestVote:
    data = BaseRequest().api_load(path_setting.TRACTATE_VOTE)
    vote_case, vote_data = get_ids(data, "tractate_vote")

    @pytest.mark.parametrize("param", vote_data, ids=vote_case)
    def test_vote(self, param):
        r = tractate_request().tractate_detail(param["current_city_id"], param["tractate_id"], param["data_type"])
        if r["error"] == 0:
            assert r["error"] == param["assert1"]
            # 如果没有点过赞，就先校验点赞之后再取消点赞。【最后保持取消点赞的状态】
            if not r["data"]["tractate_list"]["is_voted"]:
                vote = tractate_request().tractate_vote(param["tractate_id"], param["data_type"], param["reply_id"])
                assert vote["error"] == 0
                assert vote["message"] == param["message1"]
                # 取消点赞，回到取消点赞的状态
                cancelvote = tractate_request().tractate_cancelvote(param["tractate_id"], param["data_type"], param["reply_id"])
                assert cancelvote["error"] == 0
            else:
                # 如果是已经点过赞的状态就直接取消点赞
                cancelvote = tractate_request().tractate_cancelvote(param["tractate_id"], param["data_type"], param["reply_id"])
                assert cancelvote["message"] == param["message2"]




























        # r = tractate_request().tractate_detail(param["current_city_id"], param["tractate_id"], param["data_type"])
        # if r["error"] == 0:
        #     assert r["error"] == param["assert1"]
        #     # 如果没有点过赞，就先校验点赞之后再取消点赞。【最后保持取消点赞的状态】
        #     if not r["data"]["tractate_list"]["is_voted"]:
        #         vote = tractate_request().tractate_vote(param["tractate_id"], param["data_type"], param["reply_id"])
        #         assert vote["error"] == 0
        #         assert vote["message"] == param["message"]
        #         print(param["position"])
        #     #     # 取消点赞，回到取消点赞的状态
        #     #     cancelvote = tractate_request().tractate_cancelvote(param["tractate_id"], param["data_type"], param["reply_id"])
        #     #     assert cancelvote["error"] == 0
        #     elif param["position"] == 1:
        #         vote = tractate_request().tractate_vote(param["tractate_id"], param["data_type"], param["reply_id"])
        #         assert vote["error"] == 0
        #         assert vote["message"] == param["message"]
        #         print(param["position"])
        #     else:
        #         # 如果是已经点过赞的状态就直接取消点赞
        #         cancelvote = tractate_request().tractate_cancelvote(param["tractate_id"], param["data_type"], param["reply_id"])
        #         assert cancelvote["message"] == param["message"]
        #         print(param["position"])










