import pytest

import path_setting
from all_om_api.login_request import login_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#om后台-登录
class TestOmLogin:
    data = BaseRequest().api_load(path_setting.OMLOGIN)
    om_login_case, om_login_data = get_ids(data, "om_login")

    @pytest.mark.parametrize("param",om_login_data,ids=om_login_case)
    def test_om_login(self,param):
        r = login_request().om_login(param["username"], param["password"])
        if r["code"] == 0:
            print("om后台成功登陆")
            assert r["msg"] == param["assert"]
        if r["code"] != 0:
            print("om后台登陆出错")
            assert r["msg"] == param["assert"]