import pytest

from igengmei_product.common import setting_path
from igengmei_product.common.common_unit import CommonUnit
from igengmei_product.common.send_api import Sendapi


class Test_product:
    data = CommonUnit().api_data(setting_path.DATA_PRODUCT)
    print("===============", data)

    @pytest.mark.parametrize("params", data["homepage_icon_v2"])
    def test_homepage_icon_v2(self, params):
        r = Sendapi().homepage_icon_v2(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_index_v8"])
    def test_api_index_v8(self, params):
        r = Sendapi().api_index_v8(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_service_home_v5_specials"])
    def test_api_service_home_v5_specials(self, params):
        r = Sendapi().api_service_home_v5_specials(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_service_home_v5"])
    def test_api_service_home_v5(self, params):
        r = Sendapi().api_service_home_v5(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_service_home_feed"])
    def test_api_service_home_feed(self, params):
        r = Sendapi().api_service_home_feed(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_service_home_find_goods"])
    def test_api_service_home_find_goods(self, params):
        r = Sendapi().api_service_home_find_goods(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_notification_unread"])
    def test_api_notification_unread(self, params):
        r = Sendapi().api_notification_unread(**params)
        assert r["error"] == 0


    @pytest.mark.parametrize("params", data["api_visual_service_list"])
    def test_api_visual_service_list(self, params):
        r = Sendapi().api_visual_service_list(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_visual_unit_filter"])
    def test_api_visual_unit_filter(self, params):
        r = Sendapi().api_visual_unit_filter(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_visual_page_detail"])
    def test_api_visual_page_detail(self, params):
        r = Sendapi().api_visual_page_detail(**params)
        assert r["error"] == 0


    @pytest.mark.parametrize("params", data["api_shopcart_list_v2"])
    def test_api_shopcart_list_v2(self, params):
        r = Sendapi().api_shopcart_list_v2(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_category_polymer"])
    def test_api_category_polymer(self, params):
        r = Sendapi().api_category_polymer(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_feeds_tag_service"])
    def test_api_feeds_tag_service(self, params):
        r = Sendapi().api_feeds_tag_service(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_cache_data_service_filter_v1"])
    def test_api_cache_data_service_filter_v1(self, params):
        r = Sendapi().api_cache_data_service_filter_v1(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_polymerization_content"])
    def test_api_polymerization_content(self, params):
        r = Sendapi().api_polymerization_content(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_search_v2_hospital"])
    def test_api_search_v2_hospital(self, params):
        r = Sendapi().api_search_v2_hospital(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_search_v2_new_wiki"])
    def test_api_search_v2_new_wiki(self, params):
        r = Sendapi().api_search_v2_new_wiki(**params)
        assert r["error"] == 0

    @pytest.mark.parametrize("params", data["api_search_v2_doctor"])
    def test_api_search_v2_doctor(self, params):
        r = Sendapi().api_search_v2_doctor(**params)
        assert r["error"] == 0

if __name__ == '__main__':
    Test_product().test_homepage_icon_v2()


