import path_setting
from in_common.base_request import BaseRequest


class private_conversation_request(BaseRequest):
    def __init__(self):
        self.data = self.api_load(path_setting.PRIVATE_CONVERSATION_CONFIG)

    def private_conversation(self, content, target_uid, referrer,referrer_id, is_system, quick_consultation_id, diary_id, from_live):
        self.params["content"] = content
        self.params["target_uid"] = target_uid
        self.params["referrer"] = referrer
        self.params["referrer_id"] = referrer_id
        self.params["is_system"] = is_system
        self.params["quick_consultation_id"] = quick_consultation_id
        self.params["diary_id"] = diary_id
        self.params["from_live"] = from_live

        return self.api_send(self.data["private_conversation"])


if __name__ == '__main__':
    print(private_conversation_request().private_conversation("你好", "35874935", "message_home", "", 0, "", "", ""))