'''
钩子函数，解决ids乱码问题
'''
import pytest
import path_setting
from in_common.base_request import BaseRequest

data = BaseRequest().api_load(path_setting.LOGIN_FUNCTION_DATA)

def pytest_collection_modifyitems(items):
    for item in items:
        item.name = item.name.encode("utf-8").decode("unicode_escape")
        item._nodeid = item.nodeid.encode("utf-8").decode("unicode_escape")

@pytest.fixture(scope = "session",autouse=True)
def login_function():
    headers = BaseRequest().get_cookie(data["backend_login"])
    with open(path_setting.GET_COOKIE, 'w+') as f:
        f.write(str(headers))
    print("看看执行几次")