import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.conversation_request import conversation_request


class TestDetailMessageid:
    data = BaseRequest().api_load(path_setting.DETAIL_MESSAGEID)
    detailmessageid_case, detailmessageid_data = get_ids(data, "detail_messageid")


    @pytest.mark.parametrize("param",detailmessageid_data,ids=detailmessageid_case)
    def test_detail_messageid(self,param):
        r = conversation_request().detail_messageid(param["os_version"], param["last_msg_id"], param["offset_msg_id"])
        print("返回结果", r)
        if r["error"] == 0:
            results = r.get("data").get("results", [])
            assert len(results) <= param["assert"]
