import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.eyelids_request import eyelids_request


class TestDiaryCards:
    data = BaseRequest().api_load(path_setting.EYELIDS_DIARY_CARDS_DATA)
    eyelidsDiaryCards_case, eyelidsDiaryCards_data = get_ids(data, "diary_cards")

    # @pytest.mark.skip("跳过目前测试环境没有数据-------------------")
    @pytest.mark.parametrize("param",eyelidsDiaryCards_data,ids=eyelidsDiaryCards_case)
    def test_diary_cards(self,param):
        r = eyelids_request().diary_cards(param["current_city_id"], param["page"], param["page_size"],param["tag_names"])
        print("返回结果", r)
        assert r["error"] == 0




