import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.face_request import face_request


class TestPlasticFeeds:
    data = BaseRequest().api_load(path_setting.FACE_PLASTIC_FEEDS_DATA)
    plasticfeeds_case, plasticfeeds_data = get_ids(data, "plastic_feeds")

    # @pytest.mark.skip("跳过，高版本会转化标签，测试环境策略没有数据，线上正常")
    @pytest.mark.parametrize("param",plasticfeeds_data,ids=plasticfeeds_case)
    def test_plastic_feeds(self,param):
        r = face_request().plastic_feeds(param["tag_id"], param["face_id"], param["tag_id_list"], param["page_size"], param["version"])
        print("返回结果", r)
        assert r["error"] == 0



