import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestCommunity:
    data = BaseRequest().api_load(path_setting.COMMUNITY)
    community_case, community_data = get_ids(data, "community")

    @pytest.mark.parametrize("param", community_data, ids=community_case)
    def test_community(self, param):
        r = feed_request().community(param["version"], param["tabtype"], param["tags_id"], param["tab_id"])
        print("返回结果", r)
        if r["error"] == 0:
            assert r["data"]["features"][0] != param["assert"]
        # else:
        #      assert r["data"]["config_list"][0]["type"] == param["assert1"]




