import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.feed_request import feed_request


class TestFreeRecruitList:
    data = BaseRequest().api_load(path_setting.FREE_RECRUIT_LIST)
    free_recruit_list_case, free_recruit_list_data = get_ids(data, "free_recruit_list")

    @pytest.mark.parametrize("param", free_recruit_list_data, ids=free_recruit_list_case)
    def test_free_recruit_list(self, param):
        r = feed_request().free_recruit_list(param["version"], param["json"], param["tab_type"], param["page"],param["size"])
        print("返回结果", r)
        if r["error"] == 0:
            assert r["data"]["free_recruits"] != param["assert"]




