import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.filter_request import filter_request


class TestServiceHomeCityV2:
    data = BaseRequest().api_load(path_setting.FILTER)
    servicehomecityv2_case, servicehomecityv2_data = get_ids(data, "service_home_city_v2")

    @pytest.mark.parametrize("param", servicehomecityv2_data, ids=servicehomecityv2_case)
    def test_service_home_city_v2(self, param):
        r = filter_request().service_home_city_v2(param["current_city_id"], param["lat"], param["lng"])
        print("返回结果", r)
        if r["error"] == 0:
            assert len(r["data"]["area"]) > 0
