import pytest
from bs4 import BeautifulSoup

import path_setting
from all_backend_api.hybrid_request import hybrid_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#百科详情页-药品（仪器、材料）百科，菲洛嘉
class TestBaseWikiProduct:
    data = BaseRequest().api_load(path_setting.BASEWIKI_PRODUCT)
    basewiki_product_case, basewiki_product_data = get_ids(data, "basewiki_product")

    @pytest.mark.parametrize("param", basewiki_product_data, ids=basewiki_product_case)
    def test_basewiki_product(self, param):
        r = hybrid_request().basewiki_product(param["version"])
        print("返回结果", r)
        soup = BeautifulSoup(r, 'html.parser')  # html.parser是解析器，也可是lxml
        assert soup.title.string == param["assert"]
        print('进入项目百科-菲洛嘉的百科详情页')