import pytest
from bs4 import BeautifulSoup

import path_setting
from all_backend_api.hybrid_request import hybrid_request
from ids_list import get_ids
from in_common.base_request import BaseRequest

#百科详情页-品牌百科，得玛莎
class TestBrand:
    data = BaseRequest().api_load(path_setting.BRAND)
    brand_case, brand_data = get_ids(data, "brand")

    @pytest.mark.parametrize("param", brand_data, ids=brand_case)
    def test_brand(self, param):
        r = hybrid_request().brand(param["version"])
        print("返回结果", r)
        soup = BeautifulSoup(r, 'html.parser')  # html.parser是解析器，也可是lxml
        assert soup.title.string == param["assert"]
        print('进入项目百科-得玛莎的百科详情页')