import pytest

from all_backend_api.hybrid_gift_list_request import hybrid_gift_list_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestGiftListData:
    data = BaseRequest().api_load(path_setting.GIFT_LIST_DATA)
    gift_list_data_case, gift_list_data_data = get_ids(data, "gift_list_data")

    @pytest.mark.parametrize("param", gift_list_data_data, ids=gift_list_data_case)
    def test_gift_list_data(self, param):
        r = hybrid_gift_list_request().gift_list_data(param["service_id"], param["gift_type"], param["page"])
        print("返回结果", r)
        if r["error"] == 0:
            assert r["error"] == param["assert_error"]


