import pytest

from all_backend_api.janus_request import janus_request
from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest


class TestBeautyCardOrderDetailUsing:
    data = BaseRequest().api_load(path_setting.BEAUTY_CARD_ORDER_DETAIL_DATA)
    beauty_card_order_detail_using_case, beauty_card_order_detail_using_data = get_ids(data, "beauty_card_order_detail_using")

    @pytest.mark.skip
    @pytest.mark.parametrize("param", beauty_card_order_detail_using_data, ids=beauty_card_order_detail_using_case)
    def test_beauty_card_order_detail_used(self, param):
        r = janus_request().beauty_card_order_detail(param["order_id"])
        print("返回结果", r)
        data = r["data"]
        assert data["order_status"] == param["order_status"]
        assert data["vertifi_detail"]["vertifi_count"] == param["vertifi_count"]
        used_beautycard_detail = data["used_beautycard_detail"]
        title = used_beautycard_detail["title"]
        used_time = used_beautycard_detail["used_time"]
        hospital_name = used_beautycard_detail["hospital_name"]
        assert title is not None
        assert hospital_name is not None
        import datetime
        time = datetime.datetime.strptime(used_time,"%Y-%m-%d %H:%M:%S")
        assert time < datetime.datetime.now()
        print(time)

