import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.notification_request import notification_request


class TestUnread:
    data = BaseRequest().api_load(path_setting.UNREAD)
    unread_case, unread_data = get_ids(data, "unread")

    # @pytest.mark.skip
    @pytest.mark.parametrize("param",unread_data,ids=unread_case)
    def test_unread(self,param):
        r = notification_request().unread(param["uqid"], param["trace_id"])
        print("返回结果", r)
        #print("返回结果是：%s" % r)
        total_count = r["data"]["unread_count"]["total_count"]
        print("总数量是：%s" % total_count)
        total_unread = r.get("data").get("unread_count").get("follow_count").get("total_unread")#关注总未读数
        #print("总数量1是：%s" % total_unread)
        message_count = r["data"]["unread_count"]["message_count"]#私信列表总未读数
        #print("私信列表总未读数是：%s" % message_count)
        vote_favor = r["data"]["unread_count"]["vote_favor_count"]["vote_favor"]#赞/收藏总未读数
        #print("赞/收藏总未读数是：%s" % vote_favor)
        reply_count = r["data"]["unread_count"]["reply_count"]  #回复总未读数
        #print("回复总未读数是：%s" % reply_count)
        count = total_unread + message_count + vote_favor + reply_count
        #print("相加总数是是：%s" % count)
        if r["error"] == 0:
            assert r["data"]["unread_count"]["total_count"] >= param["assert"]
            assert r["data"]["unread_count"]["total_count"] == count

