import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.orders_request import orders_request


class TestOrdersMyV2Waituse:
    data = BaseRequest().api_load(path_setting.ORDERS_MY_V2_DATA)
    my_order_waituse_case, my_order_waituse_data = get_ids(data, "waituse")

    # @pytest.mark.skip
    @pytest.mark.parametrize("param",my_order_waituse_data,ids=my_order_waituse_case)
    def test_orders_waituse(self,param):
        r = orders_request().my_v2(param["start_num"], param["status"], param["version"])
        print("返回结果", r)
        if r["error"] == 0:
            orders = r["data"]["orders"]
            for order in orders:
                # 这个是次卡
                if order["type"] == 4:
                    # 订单信息
                    order_id = order["order"]["order_id"]
                    order_status = order["order"]["order_status"]["status"]
                    order_statust = order["order"]["order_status"]["text"]
                    gm_url = order["gm_url"]
                    print(order_id, order_status, order_statust, gm_url)
                    assert order_status == param["beauty_card_order_status"]
                    assert order_statust == param["beauty_card_order_statust"]
                    assert gm_url == param["beauty_card_order_gmurl"].format(order_id)
                    # 按钮信息，预约
                    beauty_card_payment_order_wait_used_title = order["buttons"][0]["title"]
                    beauty_card_payment_order_wait_used_url = order["buttons"][0]["url"]
                    assert beauty_card_payment_order_wait_used_title == param["beauty_card_button_title"]
                    assert beauty_card_payment_order_wait_used_url == param["beauty_card_button_gmurl"].format(order_id)
                    # 7.44.0加的领取面膜按钮
                    beauty_card_free_service_title = order["buttons"][1]["title"]
                    assert beauty_card_free_service_title == param["beauty_card_button_mianmo_title"]
                # 普通美购订单
                if order["type"] == 0:
                    # 订单信息
                    order_id = order["order"]["order_id"]
                    order_status = order["order"]["order_status"]["status"]
                    order_statust = order["order"]["order_status"]["text"]
                    assert order_status == param["putong_card_order_status"]
                    assert order_statust == param["putong_card_order_statust"]
                    print(order_status, order_statust)

