import pytest

import path_setting
from all_backend_api.pay_request import pay_request
from all_backend_api.settlement_request import settlement_request
from ids_list import get_ids
from in_common.base_request import BaseRequest


class TestAlipayPay:
    data = BaseRequest().api_load(path_setting.ALIPAYDATA)
    alipay_case, alipay_data = get_ids(data, "alipay_prepay")

    @pytest.mark.skip
    @pytest.mark.parametrize("param", alipay_data, ids=alipay_case)
    def test_alipay_prepay(self, param):
        create_resp = settlement_request().create_v1(param["service_item_id"],param["number"],param["platform_coupon_id"],param["use_point"],
                                       param["is_doctor_see"],param["doctor_coupon_id"],param["insurance_info"],param["is_create_groupbuy"])
        settlement_id = create_resp["data"]["id"]
        r = pay_request().alipay_prepay(settlement_id,param["version"],param["is_huabei"],param["huabei_period"])
        print(r)
        assert r["error"] == param["assert"]

