import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.personal_recommends_request import personal_recommends_request

class TestPersonalRecommends:
    data = BaseRequest().api_load(path_setting.PERSONAL_RECOMMENDS)
    personal_recommends_case, personal_recommends_data = get_ids(data, "personal_recommends")

    # @pytest.mark.skip
    @pytest.mark.parametrize("param", personal_recommends_data, ids=personal_recommends_case)
    def test_personal_recommends(self, param):
        r = personal_recommends_request().personal_recommends( param["current_city_id"], param["id"], param["from_type"] )
        print("返回结果", r)
        if r["error"] == 1:
            assert r["message"] == "没有更多数据了"
        else:
            assert r["error"] == 0

        #     assert r["data"]["text"] == param["assert_text"]
        # if r["error"] == 21001:
        #     assert r["message"] == param["assert_message1"]