import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.topicreply_vote_request import topicreply_vote_request


class TestTopicReplyVote:
    data = BaseRequest().api_load(path_setting.TOPIC_REPLY_VOTE)
    topic_reply_vote_case, topic_reply_vote_data = get_ids(data, "topic_reply_vote")

    # @pytest.mark.skip
    @pytest.mark.parametrize("param", topic_reply_vote_data, ids=topic_reply_vote_case)
    def test_topic_reply_vote(self, param):
        r = topicreply_vote_request().topic_reply_vote(param["id"])
        print("返回结果", r)
        # 先点赞一次。看是否报重复点赞的错误，如果是就先取消点赞。最后回到取消点赞的状态
        if r["error"] == 1:
            assert r["message"] == param["assert3"]
            # 回到取消点赞状态
            canclevote = topicreply_vote_request().topic_reply_cancelvote(param["id"])
            assert canclevote["error"] == 0
            # 校验点赞
            vote = topicreply_vote_request().topic_reply_vote(param["id"])
            assert vote["error"] == 0
            # 校验二次点赞无效
            vote = topicreply_vote_request().topic_reply_vote(param["id"])
            assert vote["message"] == param["assert3"]
            assert vote["error"] == 1
            # 最后取消点赞，回到取消点赞的状态
            cancelvote = topicreply_vote_request().topic_reply_cancelvote(param["id"])
            assert cancelvote["error"] == 0
        elif r["error"] == 0:
            # 说明已经点赞成功只需要校验重复点赞和取消点赞即可-二次点赞无效
            vote = topicreply_vote_request().topic_reply_vote(param["id"])
            assert vote["message"] == param["assert3"]
            assert vote["error"] == 1
            # 最后取消点赞，回到取消点赞的状态
            cancelvote = topicreply_vote_request().topic_reply_cancelvote(param["id"])
            assert cancelvote["error"] == 0


#





# if r["error"] == 1:
#     assert r["message"] ==param["assert2"]


#     收藏之后取消收藏
# r1 = diary_isfavor_request().diary_cancelfavor()
# if r["error"] == 0:
#     assert r["error"] == param["assert"]






