import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.topic_request import topic_request


class TestTopicDetail:
    data = BaseRequest().api_load(path_setting.TOPIC_DETAIL)
    topic_detail_case, topic_detail_data = get_ids(data, "topic_detail")

    # @pytest.mark.skip
    @pytest.mark.parametrize("param", topic_detail_data, ids=topic_detail_case)
    def test_v1(self, param):
        r = topic_request().topic_detail(param["topic_id"])
        print("返回结果", r)
        assert r["error"] == param["assert1"]
        if r["error"] == 0:
            assert r["error"] == param["assert1"]
            # 先判断点赞字段，日记总数等，不传值，传空值
            if r["data"]["data"]:
                assert r["data"]["data"]["is_following"] is not None and r["data"]["data"]["is_following"] is not ""   # 是否关注
                assert r["data"]["data"]["topic_num"] is not None and r["data"]["data"]["topic_num"] is not ""  # 日记贴总数
                assert r["data"]["data"]["reply_num"] is not None and r["data"]["data"]["reply_num"] is not "" # 评论数
                assert r["data"]["data"]["is_liked"] is not None and r["data"]["data"]["is_liked"] is not "" #是否点赞
                assert r["data"]["data"]["vote_num"] is not None and r["data"]["data"]["vote_num"] is not "" #点赞总数
                assert r["data"]["data"]["view_num"] is not None and r["data"]["data"]["view_num"] is not ""#浏览总数




