import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.tractate_request import tractate_request

class TestTractateDetail:
    data = BaseRequest().api_load(path_setting.TRACTATE_DETAIL)
    tractate_detail_case, tractate_detail_data = get_ids(data, "tractate_detail")

    # @pytest.mark.skip
    @pytest.mark.parametrize("param", tractate_detail_data, ids=tractate_detail_case)
    def test_detail(self, param):
        r = tractate_request().tractate_detail( param["current_city_id"], param["tractate_id"], param["data_type"] )
        print("返回结果", r)
        assert r["error"] == param["assert_error"]
        if r["error"] == 0:
            assert r["error"] == param["assert_error"]
            # 先判断有没有，然后判断里面需要的那些字段，如点赞字段，日记总数等，不传值，传空值
            if r["data"]["tractate_list"]:
                assert r["data"]["tractate_list"]["is_favored"] is not None and r["data"]["tractate_list"]["is_favored"] is not "" #是否收藏
                assert r["data"]["tractate_list"]["is_following"] is not None and r["data"]["tractate_list"]["is_following"] is not "" #是否关注
                assert r["data"]["tractate_list"]["data_type"] is not None and r["data"]["tractate_list"]["data_type"] is not "" #模版类型
                assert r["data"]["tractate_list"]["is_voted"] is not None and r["data"]["tractate_list"]["is_voted"] is not "" #是否点赞
                assert r["data"]["tractate_list"]["favor_amount"] is not None and r["data"]["tractate_list"]["favor_amount"] is not "" #收藏总数
                assert r["data"]["tractate_list"]["vote_amount"] is not None and r["data"]["tractate_list"]["vote_amount"] is not "" #点赞总数
                assert r["data"]["tractate_list"]["reply_amount"] is not None and r["data"]["tractate_list"]["reply_amount"] is not ""#评论总数
                assert r["data"]["tractate_list"]["tractate_id"] is not None and r["data"]["tractate_list"]["tractate_id"] is not ""#贴子id


            # 判断评论列表里面返回的用户信息是否为空，先判断有没有评论
            if r["data"]["tractate_list"]["reply"]:
                assert r["data"]["tractate_list"]["reply"][0]["user_id"] is not None and r["data"]["tractate_list"]["reply"][0]["user_id"] is not ""#用户id
                assert r["data"]["tractate_list"]["reply"][0]["user_name"] is not None and r["data"]["tractate_list"]["reply"][0]["user_name"] is not ""#用户名
                assert r["data"]["tractate_list"]["reply"][0]["user_portrait"] is not None and r["data"]["tractate_list"]["reply"][0]["user_portrait"] is not ""#点击头像跳转链接
        #     # assert(r[""])
        # if r["error"] == 1:
        #     assert r["error"] == param["assert_error"]
        #     assert r["data"]["text"] == param["assert_text"]
        # if r["error"] == 21001:
        #     assert r["message"] == param["assert_message1"]