import pytest

from ids_list import get_ids
import path_setting
from in_common.base_request import BaseRequest
from all_backend_api.user_request import user_request


class TestPersonalCenter:
    data = BaseRequest().api_load(path_setting.PERSONAL_CENTER)
    personalcenter_case, personalcenter_data = get_ids(data, "personal_center")

    # @pytest.mark.skip
    @pytest.mark.parametrize("param", personalcenter_data, ids=personalcenter_case)
    def test_personal_center(self, param):
        r = user_request().personal_center()
        print("返回结果", r)
        if r["error"] == 0:
         assert r["error"] == param["assert"]
         assert r["data"]["user"]["portrait"] != param["portrait"]
