#article -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import
from enum import Enum

class APP_TYPE(Enum):
    '''
        APP类型
    '''
    GENGMEI=('0','gengmei')
    LIKE=('1','like')


class CLIENT_TYPE(Enum):
    """
        端 的 来源
    """
    USER = (0, '用户版客户端')
    DOCTOR = (1, '医生版客户端')
    SHEQU = (2, '社区版客户端')  # for aso


PLATFORM_CHOICES =[
    ('android', 'ANDROID', 'Android'),
    ('iPhone', 'IPHONE', 'iPhone'),
    ('XCX', 'XCX', 'XCX'),  #小程序
]


class PLATFORM_CHANNEL(Enum):
    UNKNOWN = (0, '未知')
    IOS = (1, 'ios客户端')
    ANDROID = (2, 'android客户端')
    M = (3, 'm站')
    PC = (4, 'PC站')
    WECHAT_APP = (5, '微信小程序')
    MOMO = (6, "陌陌")
    DOCTOR = (7, "医生后台")

class CHANNEL_STATUS(Enum):
    """
    渠道记录和激活返回的状态信息
    ACT_前缀: 激活状态, ADD_前缀: 点击记录状态
    """
    ACT_INVALID_PARAMS = '激活失败, 参数不合法'
    ACT_FAIL_GENERAL = '激活失败'
    ACT_ALREADY_ACTIVATED = '激活失败, 设备已激活'
    ACT_NO_PROMOTION = '激活失败, 设备不是指定渠道推广'
    ACT_OK = '激活成功'

    ADD_INVALID_PARAMS = '记录失败, 参数不合法'
    ADD_ALREADY_ACTIVATED = '记录失败, 设备已激活'
    ADD_OK = '记录成功'
    ADD_FAIL_GENERAL = '记录失败'



class CHANNEL_CALLBACK_TYPE(Enum):
    """
    渠道回调类型
    """
    NO_CALLBACK = ('0', '无回调')
    GET_CALLBACK = ('1', 'GET回调')
    POST_CALLBACK = ('2', 'POST回调')


class PROMOTION_CHANNEL_NAME(Enum):
    """
    渠道名称列表, 规定枚举值为小写, 格式为promotion_xxxx
    """
    MALIOASO = ('promotion_malioaso', 'malioaso')
    MALIOASOSHEQU = ('promotion_malioaso-shequ', 'malioaso-shequ')
    GDT = ('promotion_gdt', '广点通')
    MCAS = ('promotion_mcas', '迈可思')
    QUMI = ('promotion_qumi', '趣米')
    AISI = ('promotion_aisi', '爱思助手')
    SHIKE = ('promotion_shike', '试客')
    ASO100 = ('promotion_aso100', 'aso100')
    QIANKA = ('promotion_qianka', '钱咖')
    DIANRU = ('promotion_dianru', '点入')
    GREENKOO = ('promotion_greenkoo', '青稞万维')
    WYZM = ('promotion_51zm', '51桌面')
    XIAOYU = ('promotion_xiaoyu', '小鱼赚钱')
    BAIDU = ('promotion_baidu', '百度')
    GOOGLE = ('promotion_google', '谷歌')
    MOMO = ('promotion_momo', '陌陌')
    TOUTIAO = ('promotion_toutiao', '今日头条')
    WANGYIYOUDAO = ('promotion_wangyiyoudao', '网易有道')
    QUTOUTIAO = ('promotion_qutoutiao', '趣头条')
    KOOMOBI = ('promotion_koomobi', '青稞万维')
    BAIDUSHOUZHU = ('promotion_bdshouzhu', '百度手助')
    DIANJING = ('promotion_dianjing', '360点睛实效平台')
    RUIYING = ('promotion_ruiying', '瑞盈aso')
    JULANG = ('promotion_julang', '聚浪aso')
    MEIYOU = ('promotion_meiyou', '美柚')
    MEITU = ('promotion_meitu', '美图')
    KXXXL = ('promotion_kxxxl', '消消乐')
    SHOUJIBAIDU = ('promotion_baiduxxl', '手机百度')