# Create your models here.

# coding=utf-8
from __future__ import unicode_literals
import datetime
import math
import json
from django.contrib.auth.models import User
from django.db import models
from django.utils import timezone
import logging
channel_logger = logging.getLogger('channel_logger')
from channels.HermesEnum import(
	APP_TYPE,
	CHANNEL_CALLBACK_TYPE, 
	CLIENT_TYPE, 
	PLATFORM_CHANNEL,
    CHANNEL_STATUS,
)

class PromotionInfo(models.Model):
    '''
        渠道商信息表
    '''
    class Meta:
        verbose_name = '渠道商信息表'
        verbose_name_plural = '渠道商信息表'
        db_table = 'promotioninfo'
    
    name = models.CharField(max_length=128, verbose_name='渠道名')
    code=models.CharField(max_length=64,verbose_name='渠道编码')
    sub_code = models.CharField(max_length=128, verbose_name='子渠道编码')
    platform=models.CharField(max_length=8,verbose_name='推广平台,IOS or Android')
    app=models.CharField(max_length=8,verbose_name="app名称",default="gengmei")
    appendtime=models.DateField(auto_now_add=True,verbose_name="创建时间")

    def __unicode__(self):
        return self.name

    def __str__(self):
        return self.name

class PromotionChannel(models.Model):
    class Meta:
        unique_together = ('device_id', 'appid','idfa','idfv','imei')
        verbose_name = '渠道推广记录'
        db_table = 'like_promotion_channel'
        app_label = 'like'

    #这里改一下吧
    app_name = models.CharField(max_length=64, verbose_name=u'app名字',default=APP_TYPE.GENGMEI.value[0])
    appid = models.CharField(max_length=64, verbose_name=u'渠道id')
    device_id = models.CharField(max_length=64, verbose_name=u'设备id')
    idfa = models.CharField(max_length=64,verbose_name=u'idfa')
    idfv = models.CharField(max_length=64, verbose_name=u'idfv')
    udid=models.CharField(max_length=64, verbose_name=u'udid')
    uuid=models.CharField(max_length=64, verbose_name=u'uuid')
    imei = models.CharField(max_length=64,verbose_name=u'imei')

    #设备物理地址
    mac = models.CharField(max_length=100, verbose_name=u'Android设备的mac', null=True, default="")
    platform = models.CharField(max_length=100,verbose_name=u'IOS或安卓类型',default=PLATFORM_CHANNEL.UNKNOWN.value[0])

    model = models.CharField(verbose_name=u'Model', null=True, max_length=40)#这是什么
    client_type = models.IntegerField(verbose_name=u'客户端类型', default=CLIENT_TYPE.USER.value[0])


    callback_type = models.CharField(max_length=2,default=CHANNEL_CALLBACK_TYPE.NO_CALLBACK.value[0])
    callback = models.CharField(max_length=1024, verbose_name=u'渠道回调', blank=True, default='')
    request = models.TextField(blank=True, verbose_name=u'点击上报请求的json', default='')
    response = models.TextField(blank=True, verbose_name=u'回调响应的json', default='')
    active_key = models.CharField(max_length=1024, verbose_name=u'激活回调需要的额外签名', default='')
    record_from = models.CharField(max_length=128, verbose_name=u'数据的来源', blank=True, default='')


    
    version = models.CharField(verbose_name=u'APP版本', null=True, max_length=10)
    os_version = models.CharField(verbose_name=u'系统版本', null=True, max_length=20)

    # Android Only
    screen = models.CharField(verbose_name=u'屏幕分辨率', null=True, max_length=40)

    # time
    create_time = models.DateTimeField(default=timezone.now, verbose_name=u'创建时间')
    active_time = models.DateTimeField(null=True, blank=True, verbose_name=u'激活时间')
    last_activity = models.DateTimeField(auto_now=True, verbose_name=u'最后活跃时间')

    def __unicode__(self):
        return self.appid

    def __str__(self):
        return self.appid


    def save(self, data=None,*args, **kwargs):

        if data:
            self.__dict__.update(data)

        super().save(*args, **kwargs)


    @staticmethod
    def filter_exists_propertys(**kwargs):
        '''
            查找出可操作字段
        '''
        #获取类的全部字段
        propertys=PromotionChannel.__dict__.keys()
        keys=kwargs.keys()
        #查找存在表中的字段
        params={key.lower().strip():value for key,value in kwargs.items() if key.lower().strip() in propertys}

        return params


    @staticmethod
    def activate(record,kwargs):
        '''
            激活设备
        '''
        params=PromotionChannel.filter_exists_propertys(**kwargs)

        record.active_time=datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        record.save(data=kwargs)

    @staticmethod
    def record(request,sub_name=None,**kwargs):
        """
        新增加渠道设备数据
        """
        params=PromotionChannel.filter_exists_propertys(**kwargs)

        #获得request的数据
        if request:
            params.update({"request":json.dumps(request.GET.dict())})


        #appid加前缀和子渠道
        appid=params.get("appid")
        appid = '{0}{1}'.format(appid,"_{0}".format(sub_name) if sub_name else "")
        params.update({"appid":appid})


        #如果callback_type不存在的话,默认为GET
        params.update({'callback_type': CHANNEL_CALLBACK_TYPE.GET_CALLBACK.value[0]})

        #保存并记录
        try:
            promotion= PromotionChannel.objects.create(**params)
        except Exception as e:
            print(e)
            return False,CHANNEL_STATUS.ADD_FAIL_GENERAL.value

        return True,''
        
