#!/usr/bin/env python
# encoding=utf-8
#from __future__ import unicode_literals

import abc
from urllib.parse import urlencode,unquote
import logging
import json
# import requests #导致循环引用
import hashlib
import time
from collections import namedtuple, OrderedDict
from django.views.decorators.csrf import csrf_exempt
from django.http import HttpResponseNotAllowed, JsonResponse, HttpResponse, Http404
from django.views.generic import View
from .models import *
from django.conf import settings
from celery import shared_task
from django.db.models import Q
import urllib
import logging
channel_logger = logging.getLogger('channel_logger')
url_logger=logging.getLogger('url_logger')


def ping(request):
    '''健康检查'''
    channel_logger.info("ping------")
    return JsonResponse(data="dong")

class Statistic(View):
    """
       点击统计
    """
    def get(self,request):
        data = request.GET.dict()

        # 迈可思, 趣米, 广点通, 爱思助手激活回调(增加点入)
        #self.async_active_callback.delay(**data)
        self.async_active_callback(**data)

        result={
            "error": 0,
            "message": "",
            "extra": {},
            "data": {},
            "user_type": {}
        }
        return JsonResponse(result)

    def post(self,request):
        data=request.POST.dict()

        # 迈可思, 趣米, 广点通, 爱思助手激活回调(增加点入)
        #self.async_active_callback.delay(**data)

        channel_logger.info("接收到的参数---")
        channel_logger.info(data)

        self.async_active_callback(**data)

        result={
            "error": 0,
            "message": "",
            "extra": {},
            "data": {},
            "user_type": {}
        }
        return JsonResponse(result)

    @csrf_exempt
    def dispatch(self, *args, **kwargs):
        return super(Statistic, self).dispatch(*args, **kwargs)

    

    #@shared_task
    def async_active_callback(self,**kwargs):
        '''
            异步激活和回调
        '''
        platform=kwargs.get('platform','')


        #设备编号相关id
        device_id=kwargs.get('device_id')

        client_type=kwargs.get("client_type",CLIENT_TYPE.USER.value[0])

        #对device_id,idfv,imei进行md5加密后再做一次查询
        def md5(string):
            if string:
                md5=hashlib.md5()
                md5.update(string.encode(encoding='utf-8'))
                return md5.hexdigest()
            return string


        #获取查询子串并对每一个关联字段做一次md5加密查询
        sub_query=[item for key,value in kwargs.items() if key in ["device_id","idfa","idfv","imei","mac"] for item in ("{0}='{1}'".format(key,value),"{0}='{1}'".format(key,md5(value)))]

        #顺序查找取第一个,如果已经激活,将不再激活
        sql="select * from like_promotion_channel where {0} order by id desc".format(" or ".join(sub_query))
        channel_logger.info(sql)
        record = PromotionChannel.objects.raw(sql)


        #如果不存在,谷歌推广
        if not record:
            kwargs.update({"appid":"google","active_time":datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')})

            platform=kwargs.get("platform","")

            channel_logger.info("platform is:{0}".format(platform))

            if platform.strip().lower()=="iphone":
                kwargs.update({"appid":"appstore"})

            if platform.strip().lower()=="android":
                kwargs.update({"appid":"mainpackage"})

            record=PromotionChannel.record(None,**kwargs)
            return

        if record:
            #如果曾经激活过,将不再激活
            for item in record:
                if item.active_time:
                    print("has activate---")
                    channel_logger.info("已激活,不能再激活---")
                    return

            record=record[0]

        channel_logger.info("存在待激活记录---")

        
        #如果已经激活,不做处理
        if record and record.active_time:
            return

        #激活
        PromotionChannel.activate(record,kwargs)

        #无回调,不做处理
        if record.callback_type==CHANNEL_CALLBACK_TYPE.NO_CALLBACK.value[0]:
            return

        #无回调url,不做处理
        if not record.callback:
            return

        url = unquote(record.callback)

        #根据平台不同,调整参数类型
        try:
            import requests
            #GET回调
            if record.callback_type == CHANNEL_CALLBACK_TYPE.GET_CALLBACK.value[0]:
                channel_logger.info(url)
                response = requests.get(url, timeout=(settings.REQUESTS_CONNECT_TIMEOUT,settings.REQUESTS_READ_TIMEOUT))

            #POST回调
            if record.callback_type == CHANNEL_CALLBACK_TYPE.POST_CALLBACK.value[0]:
                response = requests.post(url, timeout=(settings.REQUESTS_CONNECT_TIMEOUT,settings.REQUESTS_READ_TIMEOUT))

            record.response=response.text;
            record.save()

        except Exception as e:
            channel_logger.info(e)


        return {'error':0, 'msg':''}


class DoubleCheck(View):
    '''
        查重复
    '''
    request=None
    def get(self, request):
        self.request=request

        #取到渠道名称
        platform=request.path.split('/')[2]

        return DoubleCheck.__dict__.get(platform)(self)


    def zuimei(self):
        '''
            最美查重接口
        '''
        idfa_str = self.request.GET.get('idfa','')
        if not idfa_str:
            return JsonResponse({'msg':'idfa lost!', 'result':0})

        idfa_list=idfa_str.split(',')

        p=PromotionChannel.objects.filter(idfa__in=idfa_list).values_list("idfa",flat=True)

        result={idfa:'1' if idfa in p else '0' for idfa in idfa_list}

        return JsonResponse(result)





class Channel(View):
    '''
        处理请求
    '''
    request=None
    def get(self,request,sub_name=None):
        self.request=request

        platform=request.path.split('/')[2]

        url_logger.info(request.path)


        #获得处理渠道
        try:
            channel_handler=Channel.__dict__.get(platform)
        except Exception as e:
            channel_logger.info(e)
            return JsonResponse({'code':1,'failMsg':"not exists method to handle it!"})

        #处理渠道
        data,success,fail=channel_handler(self)


        result,msg=PromotionChannel.record(request,sub_name,**data)

        if not result:
            return JsonResponse(fail(msg))
        return JsonResponse(success(msg))


    def zuimei(self):
        '''
            最美点击
        '''
        data=self.request.GET.dict()
        data.update({"platform":data.pop('apptype',''),"appid":"jfq"})

        success =lambda msg:{"code":0,"failMsg":""}
        fail    =lambda msg:{'code':1,'failMsg':msg}

        return data,success,fail

    def guangdiantong(self):
        '''
            广点通(腾讯广告平台)
        '''
        data=self.request.GET.dict()
        data.update({"device_id":data.pop('muid',''),"appid":"guangdiantong"})

        success =lambda msg:{"ret":0,"failMsg":msg}
        fail    =lambda msg:{"ret":1,'failMsg':msg}

        return data,success,fail

    def kuaishou(self):
        '''
            对接快手
        '''
        data=self.request.GET.dict()

        #加入appid
        data.update({"appid":"kuaishou","idfa":data.pop("idfaMD5",""),"imei":data.pop("imeiMD5","")})

        success =lambda msg:{"ret":0,"failMsg":msg}
        fail    =lambda msg:{"ret":1,'failMsg':msg}

        return data,success,fail

    def baidu(self):
        '''
            对接百度
        '''
        channel_logger.info("处理百度平台点击请求---")


        data=self.request.GET.dict()
        channel_logger.info(data)


        callback_url=data.get("callback_url")
        try:
            callback_url=unquote(callback_url)
        except Exception as e:
            channel_logger.info(e)

        callback_url=callback_url.replace("{{ATYPE}}","activate").replace("{{AVALUE}}","0")

        #从百度拿到的akey
        akey=settings.CHANNEL_BAIDU

        #md5加密
        def get_sign():
            string=callback_url+akey
            m=hashlib.md5()
            m.update(string.encode("utf-8"))
            return m.hexdigest()

        sign=get_sign()

        callback_url=callback_url+"&sign="+sign
        data.update({"imei":data.pop("imei_md5","")})
        data.update({"callback":callback_url})
        data.update({"appid":"baidu"})

        channel_logger.info("百度end---")


        success =lambda msg:{"ret":0,"failMsg":msg}
        fail    =lambda msg:{"ret":1,'failMsg':msg}

        return data,success,fail

