# Generated by Django 2.2.1 on 2019-06-05 06:11

from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='PromotionChannel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app_name', models.CharField(default='0', max_length=64, verbose_name='app名字')),
                ('appid', models.CharField(max_length=64, verbose_name='渠道id')),
                ('device_id', models.CharField(max_length=64, verbose_name='设备id')),
                ('idfa', models.CharField(max_length=64, verbose_name='idfa')),
                ('idfv', models.CharField(max_length=64, verbose_name='idfv')),
                ('udid', models.CharField(max_length=64, verbose_name='udid')),
                ('uuid', models.CharField(max_length=64, verbose_name='uuid')),
                ('imei', models.CharField(max_length=64, verbose_name='imei')),
                ('mac', models.CharField(default='', max_length=100, null=True, verbose_name='iOS设备的idfv或Android设备的mac')),
                ('platform', models.CharField(default=0, max_length=100, verbose_name='IOS或安卓类型')),
                ('model', models.CharField(max_length=40, null=True, verbose_name='Model')),
                ('client_type', models.IntegerField(default=0, verbose_name='客户端类型')),
                ('callback_type', models.CharField(default='0', max_length=2)),
                ('callback', models.CharField(blank=True, default='', max_length=1024, verbose_name='渠道回调')),
                ('request', models.TextField(blank=True, default='', verbose_name='点击上报请求的json')),
                ('response', models.TextField(blank=True, default='', verbose_name='回调响应的json')),
                ('active_key', models.CharField(default='', max_length=1024, verbose_name='激活回调需要的额外签名')),
                ('record_from', models.CharField(blank=True, default='', max_length=128, verbose_name='数据的来源')),
                ('version', models.CharField(max_length=10, null=True, verbose_name='APP版本')),
                ('os_version', models.CharField(max_length=20, null=True, verbose_name='系统版本')),
                ('screen', models.CharField(max_length=40, null=True, verbose_name='屏幕分辨率')),
                ('channel', models.CharField(default=0, max_length=40, null=True, verbose_name='渠道')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='创建时间')),
                ('active_time', models.DateTimeField(blank=True, null=True, verbose_name='激活时间')),
                ('last_activity', models.DateTimeField(auto_now=True, verbose_name='最后活跃时间')),
            ],
            options={
                'db_table': 'like_promotion_channel',
                'verbose_name': '渠道推广记录',
                'unique_together': {('device_id', 'appid', 'idfa', 'idfv', 'imei')},
            },
        ),
    ]
