#!/usr/bin/env python
# encoding=utf-8
#from __future__ import unicode_literals

import abc
from urllib.parse import urlencode,unquote
import logging
import json
# import requests #导致循环引用
import hashlib
import time
from collections import namedtuple, OrderedDict
from django.views.decorators.csrf import csrf_exempt
from django.http import HttpResponseNotAllowed, JsonResponse, HttpResponse, Http404
from django.views.generic import View
from .models import *
from celery import shared_task
from django.db.models import Q



class Statistic(View):
    """
       点击统计
    """
    def get(self,request):
        data = request.GET.dict()

        # 迈可思, 趣米, 广点通, 爱思助手激活回调(增加点入)
        self.async_active_callback.delay(**data)
        return JsonResponse({
            "code":0,#0为成功,其他为失败
            "failMsg":"",#错误信息
        })
    

    def post(self,request):
        data=request.POST.dict()

        # 迈可思, 趣米, 广点通, 爱思助手激活回调(增加点入)
        self.async_active_callback.delay(**data)

        #self.async_active_callback(**data)
        return JsonResponse({
            "code":0,#0为成功,其他为失败
            "failMsg":"",#错误信息
        })

    @csrf_exempt
    def dispatch(self, *args, **kwargs):
        return super(Statistic, self).dispatch(*args, **kwargs)

    

    @shared_task
    def async_active_callback(**kwargs):
        '''
            异步激活和回调
        '''
        platform=kwargs.get('platform','')


        #设备编号相关id
        device_id=kwargs.get('device_id')

        client_type=kwargs.get("client_type",CLIENT_TYPE.USER.value[0])

        #获取查询子串
        sub_query=["{0}='{1}'".format(key,value) for key,value in kwargs.items() if key in ["device_id","idfa","idfv","imei","mac"]]

        #对device_id进行md5加密后再做一次查询
        if device_id:
            md5=hashlib.md5()
            md5.update(device_id.encode(encoding='utf-8'))
            md5_device_id=md5.hexdigest()
            sub_query.append("device_id='{0}'".format(md5_device_id))

        sql="select * from like_promotion_channel where {0}".format(" or ".join(sub_query))
        print(sql)
        record = PromotionChannel.objects.raw(sql)


        #如果不存在,谷歌推广
        if not record:
            kwargs.update({"appid":"google","active_time":datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')})
            record=PromotionChannel.record(None,**kwargs)
            return

        if record:
            record=record[0]

        
        #如果已经激活,不做处理
        if record and record.active_time:
            return

        #激活
        PromotionChannel.activate(record,kwargs)

        #无回调,不做处理
        if record.callback_type==CHANNEL_CALLBACK_TYPE.NO_CALLBACK.value[0]:
            return

        #无回调url,不做处理
        if not record.callback:
            return

        url = unquote(record.callback)

        #根据平台不同,调整参数类型
        try:
            import requests
            #GET回调
            if record.callback_type == CHANNEL_CALLBACK_TYPE.GET_CALLBACK.value[0]:
                print(url)
                response = requests.get(url)

            #POST回调
            if record.callback_type == CHANNEL_CALLBACK_TYPE.POST_CALLBACK.value[0]:
                response = requests.post(url)

            record.response=response.text;
            record.save()

        except Exception as e:
            print(e)
            #channel_logger.error(str(e))


        return {'error':0, 'msg':''}


class DoubleCheck(View):
    '''
        查重复
    '''
    request=None
    def get(self, request):
        self.request=request

        #取到渠道名称
        platform=request.path.split('/')[2]

        return DoubleCheck.__dict__.get(platform)(self)


    def zuimei(self):
        '''
            最美查重接口
        '''
        idfa_str = self.request.GET.get('idfa','')
        if not idfa_str:
            return JsonResponse({'msg':'idfa lost!', 'result':0})

        idfa_list=idfa_str.split(',')

        p=PromotionChannel.objects.filter(idfa__in=idfa_list).values_list("idfa",flat=True)

        result={idfa:'1' if idfa in p else '0' for idfa in idfa_list}

        return JsonResponse(result)



class Channel(View):
    '''
        处理请求
    '''
    request=None
    def get(self,request,sub_name=None):
        self.request=request

        platform=request.path.split('/')[2]

        #获得渠道数据
        try:
            data=Channel.__dict__.get(platform)(self)
        except Exception as e:
            print(str(e))
            return JsonResponse({'code':1,'failMsg':"not exists method to handle it!"})


        result,msg=PromotionChannel.record(request,sub_name,**data)

        if not result:
            return JsonResponse({'code':1,'failMsg':msg})
        return JsonResponse({"code":0,"failMsg":""})


    def zuimei(self):
        '''
            最美点击
        '''
        data=self.request.GET.dict()
        data.update({"platform":data.pop('apptype',''),"appid":"jfq"})

        return data
        