//
//  ALFaceFittingAPI.h
//  GMAlpha
//
//  Created by Jing on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GMNetworking-Swift.h"

NS_ASSUME_NONNULL_BEGIN
typedef void(^ALFaceFittingDownloadStarCompletion)(NSString * _Nullable filePath);

@interface ALFaceFittingAPI : GMObject

+ (void)fetchFaceFittingDataWithCompletion:(nullable void (^)(GMResponseOC *responseObject))completion;
+ (void)fetchStarListWithParameters:(NSDictionary *)parameters completion:(nullable void (^)(GMResponseOC *responseObject))completion;
+ (void)fetchStarFittingObjWithUrl:(NSString *)url starId:(NSString *)starId;
+ (void)fetchStarFittingObjWithUrl:(NSString *)url starId:(NSString *)starId completion:(nullable ALFaceFittingDownloadStarCompletion)completion;

+ (void)storeObjWithFilePath:(NSString *)filePath key:(NSString *)key completion:(nullable void (^)(GMResponseOC * responseObject))completion;
+ (void)unlockStarNeedShareWithParameters:(NSDictionary *)parameters completion:(void (^)(GMResponseOC * _Nonnull responseObject))completion;
+ (void)unlockStarWithParameters:(NSDictionary *)parameters completion:(nullable void (^)(GMResponseOC * responseObject))completion;

+ (nullable NSString *)fetchStarFittingObjPathWithUrl:(NSString *)url starId:(NSString *)starId completion:(nullable  ALFaceFittingDownloadStarCompletion)completion;
+ (nullable NSString *)fetchStarFittingUvPathWithUrl:(NSString *)url starId:(NSString *)starId completion:(nullable ALFaceFittingDownloadStarCompletion)completion;

@end

NS_ASSUME_NONNULL_END
