//
//  ALFaceFittingManager.m
//  GMAlpha
//
//  Created by Jing on 2018/12/7.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALFaceFittingManager.h"
#import "ALFaceFittingViewController.h"
#import "ALScanFaceCompleteViewController.h"
#import "ALFaceFittingAPI.h"
#import "ALScanManager.h"

static ALFaceFittingManager *_manager;
static NSString *ALIS_NEED_REQUEST_KEY = @"ALIsNeedRequestKey";

@implementation ALFaceFittingManager

+ (instancetype)shareInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _manager = [[ALFaceFittingManager alloc] init];
    });
    return _manager;
}

- (instancetype)init {
    if (self = [super init]) {
        _isNeedRequest = [[GMCache fetchObjectAtDocumentPathWithkey:ALIS_NEED_REQUEST_KEY] boolValue];
    }
    return self;
}

- (void)setIsNeedRequest:(BOOL)isNeedRequest {
    _isNeedRequest = isNeedRequest;
    if (isNeedRequest) [self p_requestData];
    else [GMCache removeObjectAtDocumentPathWithkey:ALIS_NEED_REQUEST_KEY];
}

- (void)p_requestData {
    if (!_isNeedRequest) return;
    NSMutableDictionary *parameters = [NSMutableDictionary new];
    [parameters setValue:[ALScanManager shareInstance].fittingId forKey:@"id"];
    [ALFaceFittingAPI fetchStarListWithParameters:parameters completion:^(GMResponseOC *responseObject) {
        if (responseObject.isSuccess) {
            NSDictionary *stars = responseObject.data[@"stars"];
            NSArray *maleStar = stars[@"male"];
            NSArray *femaleStar = stars[@"female"];
            if (maleStar.count > 0 || femaleStar.count > 0) [self p_hasData];
            else [self p_reRequestData];
        } else {
            [self p_reRequestData];
        }
    }];
}

- (void)p_hasData {
    UIViewController *vc = AppDelegate.visibleController;
    if ([vc isKindOfClass:[ALFaceFittingViewController class]]) {
        ALFaceFittingViewController *faceFittingVC = (ALFaceFittingViewController *)vc;
        [faceFittingVC reloadFaceFitting];
    } if ([vc isKindOfClass:[ALScanFaceCompleteViewController class]]) {
    } else {
        UIAlertAction *action1 = [UIAlertAction actionWithTitle:@"是" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            ALFaceFittingViewController *toVC = [[ALFaceFittingViewController alloc] init];
            [vc.navigationController pushViewController:toVC animated:YES];
        }];
        UIAlertAction *action2 = [UIAlertAction actionWithTitle:@"否" style:UIAlertActionStyleCancel handler:nil];
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"" message:@"人脸拟合成功，是否查看" preferredStyle:UIAlertControllerStyleAlert];
        [alertController addAction:action1];
        [alertController addAction:action2];
        [vc presentViewController:alertController animated:YES completion:nil];
    }
    self.isNeedRequest = NO;
}

- (void)p_reRequestData {
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(30 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self p_requestData];
    });
}

@end
