//
//  ALFaceAlertView.m
//  GMAlpha
//
//  Created by Jing on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALFaceAlertView.h"

@interface ALFaceAlertView ()

@property (nonatomic, strong) GMImageView *imageView;
@property (nonatomic, strong) GMLabel *titleLabel;
@property (nonatomic, strong) GMLabel *messageLabel;
@property (nonatomic, strong) GMLabel *messageNumLabel;
@property (nonatomic, strong) GMButton *cancelButton;
@property (nonatomic, strong) GMButton *shareWeChatButton;
@property (nonatomic, strong) GMButton *shareFriendsButton;

@end

@implementation ALFaceAlertView

- (void)setup {
    [super setup];
    self.container.layer.cornerRadius = 5;
    self.container.layer.masksToBounds = YES;
    self.animationType = GMPopupAnimationTypeSpringScaleFromCenter;
    [self.container mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(285);
        make.height.mas_equalTo(280);
        make.center.equalTo(self);
    }];
    
    _imageView = [[GMImageView alloc] initWithImage:[UIImage imageNamed:@"faceDescContent"]];
    [self.container addSubview:_imageView];
    [_imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.container);
    }];
    
    _cancelButton = [GMButton buttonWithType:UIButtonTypeCustom];
    [_cancelButton setBackgroundImage:[UIImage imageNamed:@"faceAlertCancel"] forState:UIControlStateNormal];
    [_cancelButton addTarget:self action:@selector(clickAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.container addSubview:_cancelButton];
    [_cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.top.mas_equalTo(12);
        make.right.mas_equalTo(-12);
    }];
}

- (void)setIsShare:(BOOL)isShare {
    _isShare = isShare;
    if (isShare) {
        [self.container mas_updateConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(255);
            make.height.mas_equalTo(270);
        }];
        self.imageView.image = [UIImage imageNamed:@"faceShareContent"];
        [self shareFriendsButton];
        [self shareWeChatButton];
    }
}

- (void)clickAction:(GMButton *)button {
    if (button == _cancelButton) {
        if (_clickBlock) _clickBlock(self, 0);
        [self hide];
    } else if (button == _shareWeChatButton) {
        if (_clickBlock) _clickBlock(self, 1);
    } else if (button == _shareFriendsButton) {
        if (_clickBlock) _clickBlock(self, 2);
    }
}

- (GMButton *)shareFriendsButton {
    if (!_shareFriendsButton) {
        _shareFriendsButton = [GMButton buttonWithTitle:@"分享到朋友圈" backgroundColor:RGBCOLOR_HEX(0x0093FF) titleFontSize:16 titleColor:UIColor.whiteColor];
        _shareFriendsButton.layer.cornerRadius = 18;
        _shareFriendsButton.layer.masksToBounds = YES;
        [_shareFriendsButton setImageEdgeInsets:UIEdgeInsetsMake(0, 0, 0, 5)];
        [_shareFriendsButton setTitleEdgeInsets:UIEdgeInsetsMake(0, 5, 0, 0)];
        [_shareFriendsButton setImage:[UIImage imageNamed:@"faceShareFriends"] forState:UIControlStateNormal];
        [_shareFriendsButton addTarget:self action:@selector(clickAction:) forControlEvents:UIControlEventTouchUpInside];
        [self.container addSubview:_shareFriendsButton];
        [_shareFriendsButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(200);
            make.height.mas_equalTo(36);
            make.centerX.equalTo(self.container);
            make.bottom.mas_equalTo(-28);
        }];
    }
    return _shareFriendsButton;
}

- (GMButton *)shareWeChatButton {
    if (!_shareWeChatButton) {
        _shareWeChatButton = [GMButton buttonWithTitle:@"分享到微信" backgroundColor:RGBCOLOR_HEX(0x0093FF) titleFontSize:16 titleColor:UIColor.whiteColor];
        _shareWeChatButton.layer.cornerRadius = 18;
        _shareWeChatButton.layer.masksToBounds = YES;
        [_shareWeChatButton setImageEdgeInsets:UIEdgeInsetsMake(0, 0, 0, 5)];
        [_shareWeChatButton setTitleEdgeInsets:UIEdgeInsetsMake(0, 5, 0, 0)];
        [_shareWeChatButton setImage:[UIImage imageNamed:@"faceShareWeChat"] forState:UIControlStateNormal];
        [_shareWeChatButton addTarget:self action:@selector(clickAction:) forControlEvents:UIControlEventTouchUpInside];
        [self.container addSubview:_shareWeChatButton];
        [_shareWeChatButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(200);
            make.height.mas_equalTo(36);
            make.centerX.equalTo(self.container);
            make.bottom.equalTo(self.shareFriendsButton.mas_top).offset(-16);
        }];
    }
    return _shareFriendsButton;
}

@end
