//
//  ALFaceFittingBottomView.h
//  GMAlpha
//
//  Created by Jing on 2018/11/26.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <UIKit/UIKit.h>
@class ALFaceFittingModifyView, ALFaceStarModel;

@protocol ALFaceFittingModifyViewDelegate <NSObject>

@required

/** 第一次点击明星，要去拟合*/
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view willModeifyDetails:(ALFaceStarModel *)star filePath:(NSString *)filePath UVPath:(NSString *)uvPath;

/** 第二次点击明星，进行拟合 */
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view modifyStarDetails:(ALFaceStarModel *)star;

/** 点击具体部位，调整局部细节 */
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view modifyStarDetail:(ALFaceStarModel *)star indexPath:(NSIndexPath *)indexPath;

/** 进行局部调整slider */
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view modifyDetailIndexPath:(NSIndexPath *)indexPath value:(NSInteger)value;

/** 拟合完成，点击底部完成或取消 */
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view modifyDetialsFinish:(BOOL)isFinish values:(NSArray *)values;

/** 切换男女 */
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view selettStarListIsFemale:(BOOL)isFemale;

/** 点击未解锁明星，进行解锁 */
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view unlockStar:(ALFaceStarModel *)star;

/** 点击添加明星 */
- (void)faceFittingModifyView:(ALFaceFittingModifyView *)view addStar:(BOOL)isFemale;

@end

@interface ALFaceFittingModifyView : UIView

@property (nonatomic, weak) id<ALFaceFittingModifyViewDelegate> delegate;
@property (nonatomic, strong) NSArray <ALFaceStarModel *>*starArray;
@property (nonatomic, strong) ALFaceStarModel *modifyStarModel;
@property (nonatomic, assign, readonly) BOOL isFemale;

@end
