//
//  ALFaceModifyDetailsView.m
//  GMAlpha
//
//  Created by Jing on 2018/11/26.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import "ALFaceModifyDetailsView.h"

@interface ALFaceModifyDetailsView ()

@property (nonatomic, strong) UISlider *slider;
@property (nonatomic, strong) UIButton *sliderValueButton;
@property (nonatomic, strong) UIButton *cancelButton;

@end

@implementation ALFaceModifyDetailsView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self p_setup];
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    _cancelButton.enabled = _slider.value != 50;
    [_sliderValueButton setTitle:@(_value).stringValue forState:UIControlStateDisabled];
    [_sliderValueButton mas_updateConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.slider).mas_offset((275 / 2) * (self.slider.value - 50) / 50.);
    }];
}

- (void)resetValue {
    _slider.value = 50;
    _value = _slider.value;
    [self setNeedsLayout];
}

- (void)p_cancelClick {
    _slider.value = 50;
    [self p_sliderChangeValue:_slider];
}

- (void)p_sliderChangeValue:(UISlider *)slider {
    NSInteger value = @(slider.value).integerValue;
    self.value = value;
    [self setNeedsLayout];
}

- (void)p_setup {
    _slider = [[UISlider alloc] init];
    [_slider setThumbImage:[UIImage imageNamed:@"faceModifyProgressTrack"] forState:UIControlStateNormal];
    _slider.minimumValue = 0;
    _slider.maximumValue = 100;
    _slider.minimumTrackTintColor = RGBCOLOR_HEX(0x0093FF);
    _slider.maximumTrackTintColor = RGBCOLOR_HEX(0xCCCCCC);
    _slider.value = 50;
    _value = _slider.value;
    [_slider addTarget:self action:@selector(p_sliderChangeValue:) forControlEvents:UIControlEventValueChanged];
    [self addSubview:_slider];
    [_slider mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_offset(275);
        make.top.mas_offset(85);
        make.left.mas_offset(30);
        make.height.mas_offset(16);
    }];
    
    _sliderValueButton = [GMButton buttonWithTitle:@"50" backgroundColor:UIColor.clearColor titleFontSize:14 titleColor:UIColor.whiteColor];
    [_sliderValueButton setTitleEdgeInsets:UIEdgeInsetsMake(0, 0, 4, 0)];
    [_sliderValueButton setBackgroundImage:[UIImage imageNamed:@"faceModifyProgress"] forState:UIControlStateDisabled];
    _sliderValueButton.enabled = NO;
    [self addSubview:_sliderValueButton];
    [_sliderValueButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_offset(23.5);
        make.height.mas_offset(26.7);
        make.bottom.equalTo(self.slider.mas_top).mas_offset(-10);
        make.centerX.equalTo(self.slider).mas_offset(0);
    }];
    
    _cancelButton = [GMButton buttonWithType:UIButtonTypeCustom];
    [_cancelButton setBackgroundImage:[UIImage imageNamed:@"faceModifyCancelNormal"] forState:UIControlStateNormal];
    [_cancelButton setBackgroundImage:[UIImage imageNamed:@"faceModifyCancelDisabled"] forState:UIControlStateDisabled];
    [_cancelButton addTarget:self action:@selector(p_cancelClick) forControlEvents:UIControlEventTouchUpInside];
    _cancelButton.enabled = NO;
    [self addSubview:_cancelButton];
    [_cancelButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(26);
        make.centerY.equalTo(self.slider);
        make.right.mas_equalTo(-22);
    }];
}

@end
